﻿
CKEDITOR.editorConfig = function (config) {
	config.skin = 'moono';
	config.extraPlugins = CKEDITORCUSTOM.ajaxsave;// + ',onchange,sourcedialog'; // ,codemirror'+ ',devtools'
	config.removePlugins = 'devtools';
	config.minimumChangeMilliseconds = 500; //onchange plugin
	config.disableObjectResizing = true; //image and tables http://stackoverflow.com/questions/289433/firefox-designmode-disable-image-resizing-handles
};

CKEDITOR.on('instanceReady', function (ev) {
	ev.editor.lang.prospero = CKEDITORCUSTOM.localizedString[ev.editor.langCode];
	if (ev.editor.config.Placeholder.ImageTemplate!=null) {	
		ev.editor.config.filebrowserImageUploadUrl = CKEDITORCUSTOM.uploadUrl + ev.editor.config.Placeholder.ImageTemplate.name;
	}
	if (ev.editor.config.Placeholder.FileTemplate != '') {
		ev.editor.config.filebrowserUploadUrl = CKEDITORCUSTOM.uploadUrl + ev.editor.config.Placeholder.FileTemplate;
	}
	ev.editor.on('change', function () {
		if (!ev.editor.unsaved && ev.editor.checkDirty()) {
			CKEDITORCUSTOM.setEditorSavedState(ev.editor, true);
		}
	});
	if (ev.editor.editable().isInline()) {
		ev.editor.config.Placeholder.savedData = ev.editor.getData();
		ev.editor.focus();
		ev.editor.on('blur', function (e) {
			if (!e.editor.unsaved) {
				CKEDITORCUSTOM.destroyEditor(e.editor);
			} else {
				CKEDITORCUSTOM.toggleLinks(ev.editor, true, false);
			}
		});
		ev.editor.on('focus', function (e) {
			CKEDITORCUSTOM.toggleLinks(e.editor, false, false);
		});
	}
});

CKEDITOR.on('dialogDefinition', function (ev) {
	var dialogName = ev.data.name;
	var dialogDefinition = ev.data.definition;

	if (dialogName == 'image') {
		ev.data.definition.dialog.on('load', function() {
			var urlElement = this.getContentElement('info', 'txtUrl');
			urlElement.on('change', function() {
				var size = CKEDITORCUSTOM.checkUrlIsUploaded(ev.editor, this,'');
				if (size === '') {
					ev.data.definition.dialog.getContentElement('info', 'imageSize').disable();
				} else {
					ev.data.definition.dialog.getContentElement('info', 'imageSize').enable();
				}
			});
		});
//		dialogDefinition.minHeight = 250;
//		dialogDefinition.minWidth = 420;
		dialogDefinition.removeContents('advanced');
		dialogDefinition.removeContents('Link');
		var imageInfoTab = dialogDefinition.getContents('info');
		imageInfoTab.remove('txtHSpace');
		imageInfoTab.remove('txtVSpace');
		//imageInfoTab.remove('htmlPreview'); bug: http://dev.ckeditor.com/ticket/9834
		//imageInfoTab.get('htmlPreview').align = 'left';
		imageInfoTab.remove('cmbAlign');
		imageInfoTab.remove('txtHeight');
		imageInfoTab.remove('txtWidth');
		imageInfoTab.remove('txtBorder');
		imageInfoTab.remove('ratioLock');
		imageInfoTab.get('basic').children.splice(0, 0, {
			type: 'select',
			id: 'imageSize',
			label: 'Select image size',
			items: ev.editor.config.Placeholder.ImageTemplate.imageSize,
			'default': ev.editor.config.Placeholder.ImageTemplate.defaultT,
			onChange: function (event) {
				var diag = this.getDialog();
				var urlElement = diag.getContentElement('info', 'txtUrl');
				var size = CKEDITORCUSTOM.checkUrlIsUploaded(ev.editor, urlElement,this.getValue());
				if (size === '') {
					this.setValue(this.default,true);
					event.cancel = true;
				}
			}
		});
		//dialogDefinition.getContentElement('info', 'imageSize').disable();
		var uploadTab = dialogDefinition.getContents('Upload');
        var uploadButton = uploadTab.get('uploadButton');
		uploadButton['filebrowser']['onSelect'] = function(fileUrl, errorMessage) {
			if (errorMessage==='') {
				ev.data.definition.dialog.getContentElement('info', 'imageSize').enable();
			}
		};
	}
	if (dialogName == 'link') {
		dialogDefinition.removeContents('advanced');
		dialogDefinition.removeContents('target');
		//var linkInfoTab = dialogDefinition.getContents('info');
	}
});

CKEDITOR.plugins.add(CKEDITORCUSTOM.ajaxsave, {
	init: function (editor) {

		editor.ui.addButton(CKEDITORCUSTOM.ajaxsave, {
			label: editor.lang.save.toolbar,
			command: CKEDITORCUSTOM.ajaxsave,
			icon: 'save'
		});
		editor.addCommand(CKEDITORCUSTOM.ajaxsave,
								{
									exec: function (ed) {
										ed.updateElement();
										var content = ed.getData();
										var jsonInput = { 'dbName': ed.config.Placeholder.Name, 'pagePath': ed.config.Placeholder.PagePath, 'language': ed.config.language, 'cmsEditor': ed.config.Placeholder.CmsEditor, 'content': content };
										CKEDITORCUSTOM.CallAjax(ed.config.Placeholder.WsUrl, JSON.stringify(jsonInput),
											function (returnData) {
												if (returnData == '') {
													ed.config.Placeholder.savedData = content;
													ed.resetUndo();
													CKEDITORCUSTOM.setEditorSavedState(ed, false);
													noty({ text: ed.lang.tempName.contentSaved1 + ed.config.Placeholder.Name + ed.lang.tempName.contentSaved2, type: 'success', timeout: 4000 });
												} else {
													noty({ text: returnData, type: 'error', timeout: false, modal: true, closeWith: ['button'] });
												}
											}, true);
									},
									canUndo: true
								});
	}
});

window.onbeforeunload = CKEDITORCUSTOM.closeWarning;